-- Macro Scripts File
-- Created:  10 december 2003
-- Version:  3ds MAX 7
-- Author:   Michaelson Britt
-- VertexPaint action items
--************************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

macroScript VertexPaint_IgnoreBackfacing
category:~VERTEXPAINT_IGNOREBACKFACING_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_IGNOREBACKFACING_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_IGNOREBACKFACING_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			m.ignoreBackfacing = not m.ignoreBackfacing
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		( (classof m) == VertexPaint )	
	)

	on isChecked do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			m.ignoreBackfacing
		)
		else false
	)
) --VertexPaint_IgnoreBackfacing

macroScript VertexPaint_MaskUnselected
category:~VERTEXPAINT_MASKUNSELECTED_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_MASKUNSELECTED_TOOLTIP~		--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_MASKUNSELECTED_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			m.hideUnselSubobjs = not m.hideUnselSubobjs
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		( (classof m) == VertexPaint )	
	)

	on isChecked do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			m.hideUnselSubobjs
		)
		else false
	)
) --VertexPaint_MaskUnselected

macroScript VertexPaint_LayerOpacityUp
category:~VERTEXPAINT_LAYEROPACITYUP_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_LAYEROPACITYUP_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_LAYEROPACITYUP_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local opacity = m.layerOpacity
			if( opacity>95 ) then m.layerOpacity = 100
			else m.layerOpacity = (opacity+5)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			(m.layerOpacity<100)
		)
		else false
	)
) --VertexPaint_LayerOpacityUp

macroScript VertexPaint_LayerOpacityDown
category:~VERTEXPAINT_LAYEROPACITYDOWN_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_LAYEROPACITYDOWN_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_LAYEROPACITYDOWN_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local opacity = m.layerOpacity
			if( opacity<5 ) then m.layerOpacity = 0
			else m.layerOpacity = (opacity-5)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			(m.layerOpacity>0)
		)
		else false
	)

) --VertexPaint_LayerOpacityDown


macroScript VertexPaint_PaintChannelUp
category:~VERTEXPAINT_PAINTCHANNELUP_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_PAINTCHANNELUP_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_PAINTCHANNELUP_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local channel = m.mapChannel
			if( channel < 99 ) do m.mapChannel = (channel+1)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			(m.mapChannel < 99)
		)
		else false
	)

) --VertexPaint_PaintChannelUp

macroScript VertexPaint_PaintChannelDown
category:~VERTEXPAINT_PAINTCHANNELDOWN_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_PAINTCHANNELDOWN_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_PAINTCHANNELDOWN_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local channel = m.mapChannel
			if( channel > -2 ) do m.mapChannel = (channel-1)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			(m.mapChannel > -2)
		)
		else false
	)

) --VertexPaint_PaintChannelDown

macroScript VertexPaint_DisplayChannelUp
category:~VERTEXPAINT_DISPLAYCHANNELUP_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_DISPLAYCHANNELUP_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_DISPLAYCHANNELUP_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local channel = t.mapDisplayChannel
			if( (not t.mapDisplayChannelLock) and (channel < 99) ) do
				t.mapDisplayChannel = (channel+1)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			local t = vertexPaintTool()
			((not t.mapDisplayChannelLock) and (t.mapDisplayChannel < 99))
		)
		else false
	)

) --VertexPaint_DisplayChannelUp

macroScript VertexPaint_DisplayChannelDown
category:~VERTEXPAINT_DISPLAYCHANNELDOWN_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_DISPLAYCHANNELDOWN_TOOLTIP~ --LOC_NOTES:localize this
buttontext:~VERTEXPAINT_DISPLAYCHANNELDOWN_BUTTONTEXT~			--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local channel = t.mapDisplayChannel
			if( (not t.mapDisplayChannelLock) and (channel > -2) ) do
				t.mapDisplayChannel = (channel-1)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			local t = vertexPaintTool()
			((not t.mapDisplayChannelLock) and (t.mapDisplayChannel > -2))
		)
		else false
	)

) --VertexPaint_DisplayChannelDown

macroScript VertexPaint_LockDisplayChannel
category:~VERTEXPAINT_LOCKDISPLAYCHANNEL_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_LOCKDISPLAYCHANNEL_TOOLTIP~ --LOC_NOTES:localize this
buttontext:~VERTEXPAINT_LOCKDISPLAYCHANNEL_BUTTONTEXT~			--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()		
			t.mapDisplayChannelLock = not t.mapDisplayChannelLock
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		( (classof m) == VertexPaint )
	)

	on isChecked do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			(vertexPaintTool()).mapDisplayChannelLock
		)
		else false
	)
) --VertexPaint_LockDisplayChannel

macroScript VertexPaint_BrushSizeUp
category:~VERTEXPAINT_BRUSHSIZEUP_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_BRUSHSIZEUP_TOOLTIP~		--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_BRUSHSIZEUP_BUTTONTEXT~					--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local size = t.brushSize
			if( size>0 ) do t.brushSize *= (6.0/5.0)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		( (classof m) == VertexPaint )
	)
) --VertexPaint_BrushSizeUp

macroScript VertexPaint_BrushSizeDown
category:~VERTEXPAINT_BRUSHSIZEDOWN_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_BRUSHSIZEDOWN_TOOLTIP~		--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_BRUSHSIZEDOWN_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local size = t.brushSize
			--if( size<... ) do --FIXME: should there be an upper limit?
				t.brushSize *= (5.0/6.0)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		( (classof m) == VertexPaint )
	)
) --VertexPaint_BrushSizeDown

macroScript VertexPaint_BrushOpacityUp
category:~VERTEXPAINT_BRUSHOPACITYUP_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_BRUSHOPACITYUP_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_BRUSHOPACITYUP_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local opacity = t.brushOpacity
			if( opacity>95 ) then t.brushOpacity = 100
			else t.brushOpacity = (opacity+5)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			((vertexPaintTool()).brushOpacity<100)
		)
		else false
	)
) --VertexPaint_BrushOpacityUp

macroScript VertexPaint_BrushOpacityDown
category:~VERTEXPAINT_BRUSHOPACITYDOWN_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_BRUSHOPACITYDOWN_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_BRUSHOPACITYDOWN_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local opacity = t.brushOpacity
			if( opacity<5 ) then t.brushOpacity = 0
			else t.brushOpacity = (opacity-5)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			((vertexPaintTool()).brushOpacity>0)
		)
		else false
	)
) --VertexPaint_BrushOpacityDown

macroScript VertexPaint_MirrorMode
category:~VERTEXPAINT_MIRRORMODE_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_MIRRORMODE_TOOLTIP~			--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_MIRRORMODE_BUTTONTEXT~					--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			t.mirrorMode = not t.mirrorMode
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		( (classof m) == VertexPaint )
	)

	on isChecked do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			(vertexPaintTool()).mirrorMode
		)
		else false
	)
) --VertexPaint_MirrorMode

macroScript VertexPaint_MirrorModeAxis
category:~VERTEXPAINT_MIRRORMODEAXIS_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_MIRRORMODEAXIS_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_MIRRORMODEAXIS_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()		
			local axis = t.mirrorModeAxis
			if( axis==2 ) then t.mirrorModeAxis = 0
			else t.mirrorModeAxis = (axis+1) 
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		( (classof m) == VertexPaint )
	)
) --VertexPaint_MirrorModeAxis

macroScript VertexPaint_PaintMode
category:~VERTEXPAINT_PAINTMODE_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_PAINTMODE_TOOLTIP~			--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_PAINTMODE_BUTTONTEXT~					--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local mode = t.curPaintMode
			if( (mode==0) or (mode==2) or (mode==8) ) then
				t.curPaintMode = 1
			else if( mode==1 ) do
				t.curPaintMode = 0
			
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) then
		(
			local mode = (vertexPaintTool()).curPaintMode
			true
		)
		else false
	)

	on isChecked do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			((vertexPaintTool()).curPaintMode == 1)
		)
		else false
	)
) --VertexPaint_PaintMode

macroScript VertexPaint_PickMode
category:~VERTEXPAINT_PICKMODE_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_PICKMODE_TOOLTIP~			--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_PICKMODE_BUTTONTEXT~					--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local mode = t.curPaintMode
			if( (mode==0) or (mode==1) or (mode==2) or (mode==9) ) then
				t.curPaintMode = 8
			else if( mode==8 ) do
				t.curPaintMode = 0
			
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) then
		(
			local mode = (vertexPaintTool()).curPaintMode
			true
		)
		else false
	)

	on isChecked do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			((vertexPaintTool()).curPaintMode == 8)
		)
		else false
	)
) --VertexPaint_PickMode

macroScript VertexPaint_EraseMode
category:~VERTEXPAINT_ERASEMODE_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_ERASEMODE_TOOLTIP~			--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_ERASEMODE_BUTTONTEXT~						--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local mode = t.curPaintMode
			if( (mode==0) or (mode==1) or (mode==8) or (mode==9) ) then
				t.curPaintMode = 2
			else if( mode==2 ) do
				t.curPaintMode = 0
			
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) then
		(
			local mode = (vertexPaintTool()).curPaintMode
			true
		)
		else false
	)

	on isChecked do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			((vertexPaintTool()).curPaintMode == 2)
		)
		else false
	)
) --VertexPaint_EraseMode

macroScript VertexPaint_BlurBrushMode
category:~VERTEXPAINT_BLURBRUSHMODE_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_BLURBRUSHMODE_TOOLTIP~			--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_BLURBRUSHMODE_BUTTONTEXT~						--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local mode = t.curPaintMode
			if( (mode==0) or (mode==1) or (mode==2) or (mode==8) ) then
				t.curPaintMode = 9
			else if( mode==2 ) do
				t.curPaintMode = 0
			
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) then
		(
			local mode = (vertexPaintTool()).curPaintMode
			true
		)
		else 
		(
			false
		)
	)

	on isChecked do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then
		(
			((vertexPaintTool()).curPaintMode == 9)
		)
		else 
		(
			false
		)
	)
) --VertexPaint_BlurBrushMode

